#include "uplayer.hpp"
#include "chess.hpp"
#include "chessui.hpp"

GAMESTATUS USERPLAYER::play(BOARD &board) const
  {
    BOARDMETRIC metric;

    board.findBestMoves(2, whatColor(), metric, (BESTMOVES *) 0);
    switch (metric.kingSituation[whatColor()])
      {
      case KINGLOST:
	ChessUI.mated(whatColor());
	return(GAMEOVER);

      case STALEMATE:
	ChessUI.staleMated(whatColor());
	return(GAMEOVER);

      case KINGOK:
	break;
      }

    if (!ChessUI.userMove(board, whatColor()))
      return(GAMEOVER);
    return(GAMECONTINUE);
  }
